<?php
function register_new_widgets( $widgets_manager ) {

	require_once( __DIR__ . '/base/video-widget.php' );

	$widgets_manager->register( new \Custom_Video_Widget() );

}
add_action( 'elementor/widgets/register', 'register_new_widgets' );


//add_action( 'elementor/controls/controls_registered', function( $controls_manager ) {
//	require_once( __DIR__ . '/base/date-widget.php' );
//
//	$controls_manager->register_control( 'persian_date_picker', new \Control_Persian_Date_Picker() );
//} );

add_action('elementor/element/countdown/section_countdown/before_section_end', function($element, $args) {
    $checkbox_value = get_option('my_custom_elementor_checkbox');
    if (!$checkbox_value) {
        // Add custom control before 'due_date'
        $element->add_control(
            'shamsi_due_date',
            [
                'label' => "تاریخ تحویل شمسی",
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => gmdate( 'Y-m-d H:i', strtotime( '+1 month' ) + ( get_option( 'gmt_offset' ) * HOUR_IN_SECONDS ) ),
                'description' => "برای استفاده از تاریخ شمسی کلیک کنید",
                'classes' => "shamsi_due_date",
                'ai' => false,
            ]
        );
    }

}, 10, 2);



function register_and_enqueue_widget_styles() {
    // Register styles and scripts
    wp_register_style('pDate-style', plugins_url('elementor-pro') . '/megatheme/includes/assets/css/persian-datepicker.min.css');
    wp_register_script('pDate', plugins_url('elementor-pro') . '/megatheme/includes/assets/js/persian-date.min.js', array('jquery'), null, true);
    wp_register_script('pDatepicker', plugins_url('elementor-pro') . '/megatheme/includes/assets/js/persian-datepicker.min.js', array('pDate'), null, true);
    wp_register_script('pDatepickerLoader', plugins_url('elementor-pro') . '/megatheme/includes/assets/js/persian-datepicker-loader.js', array('pDatepicker'), null, true);

    // Enqueue the registered styles and scripts
    wp_enqueue_style('pDate-style');
    wp_enqueue_script('pDate');
    wp_enqueue_script('pDatepicker');
    wp_enqueue_script('pDatepickerLoader');
}

add_action('wp_enqueue_scripts', 'register_and_enqueue_widget_styles', 20);

function register_and_enqueue_editor_styles() {
    $checkbox_value = get_option('my_custom_elementor_checkbox');
    if (!$checkbox_value) {
        // Add custom control before 'due_date'
        // Register styles and scripts for Elementor editor
        wp_register_style('pDate-style', plugins_url('elementor-pro') . '/megatheme/includes/assets/css/persian-datepicker.min.css');
        wp_register_script('pDate', plugins_url('elementor-pro') . '/megatheme/includes/assets/js/persian-date.min.js', array('jquery'), null, true);
        wp_register_script('pDatepicker', plugins_url('elementor-pro') . '/megatheme/includes/assets/js/persian-datepicker.min.js', array('pDate'), null, true);
        wp_register_script('pDatepickerLoader', plugins_url('elementor-pro') . '/megatheme/includes/assets/js/persian-datepicker-loader.js', array('pDatepicker'), null, true);

        // Enqueue the registered styles and scripts for Elementor editor
        wp_enqueue_style('pDate-style');
        wp_enqueue_script('pDate');
        wp_enqueue_script('pDatepicker');
        wp_enqueue_script('pDatepickerLoader');
    }
}

add_action('elementor/editor/after_enqueue_scripts', 'register_and_enqueue_editor_styles');

// Add a section to the Elementor settings page
function my_custom_elementor_settings_section() {
	add_settings_section('my_custom_elementor_section', 'My Custom Elementor Settings', 'my_custom_elementor_section_callback', 'elementor');
}

// Section callback function
function my_custom_elementor_section_callback() {
	echo '<p>Customize your Elementor settings here.</p>';
}

// Add a checkbox field to the section
function my_custom_elementor_checkbox_field() {
	add_settings_field('my_custom_elementor_checkbox', 'غیر فعال سازی تاریخ شمسی', 'my_custom_elementor_checkbox_callback', 'elementor', 'elementor_general_section');
	add_settings_field('mc_enable_ai', 'فعال سازی هوش مصنوعی', 'mc_enable_ai_callback', 'elementor', 'elementor_general_section');
	register_setting('elementor', 'my_custom_elementor_checkbox');
	register_setting('elementor', 'mc_enable_ai');
}

// Checkbox callback function
function my_custom_elementor_checkbox_callback() {
	$value = get_option('my_custom_elementor_checkbox');
	echo '<input type="checkbox" name="my_custom_elementor_checkbox" value="1" ' . checked(1, $value, false) . ' />';
}
// Checkbox callback function
function mc_enable_ai_callback() {
	$value = get_option('mc_enable_ai');
	echo '<input type="checkbox" name="mc_enable_ai" value="1" ' . checked(1, $value, false) . ' /><span>با فعال شدن این گزینه ممکنه به خاطر مشکلات زیرساختی اینترنت، سرعت افزونه کم یا سایت شما با کندی مواجه شود.</span>';
}

// Hook into the Elementor settings page
add_action('admin_init', 'my_custom_elementor_checkbox_field');
add_action('admin_init', 'my_custom_elementor_settings_section');

add_action('init',function (){
    if (!get_option('mc_enable_ai')) {
        define('WP_ACCESSIBLE_HOSTS', '*.akismet.com,*.shaparak.ir:8080,*.shaparak.ir,*.zarinpal.com,*.zibal.ir,*.idpay.ir,pay.ir,*.pay.ir,nextpay.org,*.enamad.ir,*.mydigipay.com,ippanel.com,*.payamak-panel.com,*.sms.ir,wordpress.org');
    }
});


